﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;

namespace OcadMapLibrary {

	public class PointSymbol : MapSymbol {

		public PointSymbol() {
			pointSymbolElements = new List<PointSymbolElement>();
		}

		List<PointSymbolElement> pointSymbolElements;
		public List<PointSymbolElement> PointSymbolElements {
			get {
				return pointSymbolElements;
			}
		}

		public bool ContainsColor(MapColor mapColor) {
			for (int i = 0; i < pointSymbolElements.Count; i++) {
				if (pointSymbolElements[i].ContainsColor(mapColor)) {
					return true;
				}
			}
			return false;
		}

		public void DrawSymbol(DrawingContext drawingContext, MapColor mapColor) {
			if (IsHidden) {
				return;
			}
			for (int i = 0; i < pointSymbolElements.Count; i++) {
				pointSymbolElements[i].Draw(drawingContext, mapColor);
			}
		}

		public Rect GetBoundingRect(Point position) {
			Rect rect = Rect.Empty;
			if (IsHidden) {
				return rect;
			}
			for (int i = 0; i < pointSymbolElements.Count; i++) {
				Rect temp = pointSymbolElements[i].GetBoundingRect(position);
				rect.Union(temp);
			}
			return rect;
		}

	}

}
