﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;

namespace OcadMapLibrary {

	public class PointObject : MapObject {

		Point position;
		public Point Position {
			get {
				return position;
			}
			set {
				position = value;
			}
		}

		double rotation;
		public double Rotation {
			get {
				return rotation;
			}
			set {
				rotation = value;
			}
		}

		public override void DrawObject(DrawingContext drawingContext, List<MapSymbol> mapSymbols, MapColor mapColor) {
			PointSymbol symbol = (PointSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return;
			}
			if (!symbol.ContainsColor(mapColor)) {
				return;
			}
			TranslateTransform translate = new TranslateTransform(position.X, position.Y);
			drawingContext.PushTransform(translate);
			if (Rotation != 0) {
				RotateTransform rotate = new RotateTransform(Rotation);
				drawingContext.PushTransform(rotate);
			}
			symbol.DrawSymbol(drawingContext, mapColor);
			if (Rotation != 0) {
				drawingContext.Pop();
			}
			drawingContext.Pop();
		}

		public override Rect GetBoundingRect(List<MapSymbol> mapSymbols) {
			PointSymbol symbol = (PointSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			Rect rect = Rect.Empty;
			if (symbol == null) {
				return rect;
			}
			return symbol.GetBoundingRect(Position);
		}

	}

}
