﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace OcadMapLibrary {

	public abstract class MapPathSegment {

		public abstract double GetLength(Point startPoint);

		public abstract bool HasLength(Point startPoint);

		public abstract double GetAngleAtLength(Point startPoint, double length);

		public abstract double GetAngleAtStart(Point startPoint);

		public abstract double GetAngleAtEnd(Point startPoint);

		public abstract Point? GetPointAtLength(Point startPoint, double length);

		public abstract PathSegment GetPathSegment();

		public abstract List<MapPathSegment> SplitAtLength(Point startPoint, double length);

		public abstract List<MapLineSegment> Flatten(Point startPoint);

		public abstract MapPathSegment Clone();

		public abstract void Reverse(Point oldStartPoint);
		
		Point endPoint;
		public Point EndPoint {
			get {
				return endPoint;
			}
			set {
				if (endPoint != value) {
					DataChanged();
				}
				endPoint = value;
			}
		}

		bool isLeftStroked;
		public bool IsLeftStroked {
			get {
				return isLeftStroked;
			}
			set {
				isLeftStroked = value;
			}
		}

		bool isRightStroked;
		public bool IsRightStroked {
			get {
				return isRightStroked;
			}
			set {
				isRightStroked = value;
			}
		}


		//These refer to the end point

		bool isCornerPoint;
		public bool IsCornerPoint {
			get {
				return isCornerPoint;
			}
			set {
				isCornerPoint = value;
			}
		}

		bool isDashPoint;
		public bool IsDashPoint {
			get {
				return isDashPoint;
			}
			set {
				isDashPoint = value;
			}
		}

		protected void PopulateCloneBase(MapPathSegment clone) {
			clone.EndPoint = EndPoint;
			clone.IsCornerPoint = IsCornerPoint;
			clone.IsDashPoint = IsDashPoint;
			clone.IsLeftStroked = IsLeftStroked;
			clone.IsRightStroked = IsRightStroked;
		}

		protected virtual void DataChanged() {
		}

	}

}
