﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;

namespace OcadMapLibrary {

	public class MapAreaGeometry {

		public MapAreaGeometry() {
			holes = new List<MapPathFigure>();
			mainFigure = new MapPathFigure();
		}

		MapPathFigure mainFigure;
		public MapPathFigure MainFigure {
			get {
				return mainFigure;
			}
			set {
				mainFigure = value;
			}
		}

		List<MapPathFigure> holes;
		public List<MapPathFigure> Holes {
			get {
				return holes;
			}
		}

		public PathGeometry GetGeometry() {
			PathGeometry result = MainFigure.GetGeometry();
			for (int i = 0; i < Holes.Count; i++) {
				result = Geometry.Combine(result, Holes[i].GetGeometry(), GeometryCombineMode.Xor, null);
			}
			return result;
		}

	}

}
