﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;

namespace OcadMapLibrary {

	public class LineTextObject : MapObject {

		MapPathFigure data;
		public MapPathFigure Data {
			get {
				return data;
			}
			set {
				data = value;
			}
		}

		string text;
		public string Text {
			get {
				return text;
			}
			set {
				text = value;
			}
		}

		public override void DrawObject(DrawingContext drawingContext, List<MapSymbol> mapSymbols, MapColor mapColor) {
			LineTextSymbol symbol = (LineTextSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return;
			}
			symbol.DrawSymbol(Text, Data, drawingContext, mapColor);
		}

		public override Rect GetBoundingRect(List<MapSymbol> mapSymbols) {
			LineTextSymbol symbol = (LineTextSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return Rect.Empty;
			}
			return symbol.GetBoundingRect(Text, Data);
		}

	}

}
