﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;

namespace OcadMapLibrary {

	public class LineObject : MapObject {

		MapPathFigure data;
		public MapPathFigure Data {
			get {
				return data;
			}
			set {
				data = value;
			}
		}

		public override void DrawObject(DrawingContext drawingContext, List<MapSymbol> mapSymbols, MapColor mapColor) {
			LineSymbol symbol = (LineSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return;
			}
			symbol.DrawSymbol(Data, drawingContext, mapColor);
		}

		public override Rect GetBoundingRect(List<MapSymbol> mapSymbols) {
			LineSymbol symbol = (LineSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return Rect.Empty;
			}
			return symbol.GetBoundingRect(Data);
		}

	}

}
