﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;

namespace OcadMapLibrary {

	public class AreaObject : MapObject {

		MapAreaGeometry data;
		public MapAreaGeometry Data {
			get {
				return data;
			}
			set {
				data = value;
			}
		}

		double fillRotation;
		public double FillRotation {
			get {
				return fillRotation;
			}
			set {
				fillRotation = value;
			}
		}

		public override void DrawObject(DrawingContext drawingContext, List<MapSymbol> mapSymbols, MapColor mapColor) {
			AreaSymbol symbol = (AreaSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return;
			}
			symbol.DrawSymbol(Data, FillRotation, drawingContext, mapColor);
		}

		public override Rect GetBoundingRect(List<MapSymbol> mapSymbols) {
			AreaSymbol symbol = (AreaSymbol)TargetSymbol.GetMapSymbol(mapSymbols);
			if (symbol == null) {
				return Rect.Empty;
			}
			return symbol.GetBoundingRect(Data);
		}

	}

}
