﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace OPlanner {
	
	public partial class ScaleCoordinates : Window {

		public ScaleCoordinates() {
			InitializeComponent();
		}

		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
			Clear();
		}

		private void Clear() {
			scaleBox.Text = "100";
		}

		private bool Validate(bool showErrors) {
			ErrorManager errorManager = new ErrorManager();
			double num;
			if (scaleBox.Text == "") {
				errorManager.AddError("Scale by is required");
			} else {
				if (!double.TryParse(scaleBox.Text, out num)) {
					errorManager.AddError("Scale by must be a number");
				} else {
					if (num <= 0) {
						errorManager.AddError("Scale by must be a positive number");
					}
				}
			}
			if (showErrors) {
				errorManager.ShowErrors(this);
			}
			return !errorManager.HasErrors;
		}

		private void scaleButton_Click(object sender, RoutedEventArgs e) {
			if (!Validate(true)) {
				return;
			}
			double scale = double.Parse(scaleBox.Text);
			double fraction = scale / 100;
			info.InvokeDataChanging(this, "Scale Coordinates");
			for (int i = 0; i < info.Data.OObjects.Count; i++) {
				if (info.Data.OObjects[i] is IMapObject) {
					IMapObject mapObj = (IMapObject)info.Data.OObjects[i];
					mapObj.X *= fraction;
					mapObj.Y *= fraction;
				}
			}
			for(int j = 0; j < info.Data.Courses.Count;j++){
				for (int i = 0; i < info.Data.Courses[j].OObjects.Count; i++) {
					if (info.Data.Courses[j].OObjects[i] is IMapObject) {
						IMapObject mapObj = (IMapObject)info.Data.Courses[j].OObjects[i];
						mapObj.X *= fraction;
						mapObj.Y *= fraction;
					}
				}
			}
			info.InvokeDataChanged(this, "Scale Coordinates");
			info.InvokeObjectsUpdated(this, UpdateType.Move, null, true);
			Close();
		}

		private void cancelButton_Click(object sender, RoutedEventArgs e) {
			Close();
		}

	}

}
