﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace OPlanner {

	public class OTransparentAreaVisual : OObjectVisual {

		private Grid mainContainer;
		private Ellipse outlineVisual;

		public OTransparentAreaVisual() {
			outlineVisual = new Ellipse();
			outlineVisual.Fill = new RadialGradientBrush((Color)ColorConverter.ConvertFromString("#000000FF"), (Color)ColorConverter.ConvertFromString("#330000FF"));
			mainContainer = new Grid();
			mainContainer.Children.Add(outlineVisual);
			MainVisual.Content = mainContainer;
		}

		public override void UpdateObject(UpdateType updateType) {
			base.UpdateObject(updateType);
			if (updateType == UpdateType.Move) {
				DrawObject();
			}
		}

		protected override void DrawObject() {
			base.DrawObject();
			OTransparentArea obj = (OTransparentArea)ObjectData.GetObject(typeof(OTransparentArea));
			if (obj == null) {
				return;
			}
			double size = obj.Size;
			outlineVisual.Width = size * 2;
			outlineVisual.Height = size * 2;
			outlineVisual.Margin = new Thickness(-size, -size, size, size);
			if (info.CourseViewType == CourseViewType.Outline) {
				outlineVisual.Visibility = Visibility.Visible;
			} else {
				outlineVisual.Visibility = Visibility.Collapsed;
			}
		}

		public override Rect GetVisualBounds() {
			OTransparentArea obj = (OTransparentArea)ObjectData.GetObject(typeof(OTransparentArea));
			if (obj == null) {
				return Rect.Empty;
			}
			double size = obj.Size;
			return new Rect(-size, -size, size * 2, size * 2);
		}

	}

}
