﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows;

namespace OPlanner {

	public class OToolButton : RadioButton {

		public static DependencyProperty ToolTypeProperty;
		public static DependencyProperty CreateModeProperty;
		public static DependencyProperty DrawingModeProperty;

		static OToolButton() {
			ToolTypeProperty = DependencyProperty.Register("ToolType", typeof(ToolType), typeof(OToolButton), new PropertyMetadata(ToolType.None));
			CreateModeProperty = DependencyProperty.Register("CreateMode", typeof(CreateMode), typeof(OToolButton), new PropertyMetadata(CreateMode.None));
			DrawingModeProperty = DependencyProperty.Register("DrawingMode", typeof(DrawingMode), typeof(OToolButton), new PropertyMetadata(DrawingMode.None));
		}

		public ToolType ToolType {
			get {
				return (ToolType)base.GetValue(ToolTypeProperty);
			}
			set {
				base.SetValue(ToolTypeProperty, value);
			}
		}

		public CreateMode CreateMode {
			get {
				return (CreateMode)base.GetValue(CreateModeProperty);
			}
			set {
				base.SetValue(CreateModeProperty, value);
			}
		}

		public DrawingMode DrawingMode {
			get {
				return (DrawingMode)base.GetValue(DrawingModeProperty);
			}
			set {
				base.SetValue(DrawingModeProperty, value);
			}
		}

	}

}
