﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows;
using System.Windows.Input;
using System.Windows.Xps;
using System.Windows.Xps.Packaging;
using Microsoft.Win32;
using System.IO;
using System.IO.Packaging;
using System.Printing;
using System.Windows.Markup;
using System.Windows.Documents;

namespace OPlanner {

	public class CustomComboBoxItem : ComboBoxItem {

		public object ObjectData;

		public CustomComboBoxItem() {
		}

		public CustomComboBoxItem(object content, object data) {
			ObjectData = data;
			Content = content;
		}

	}

	public class CustomListBoxItem : ListBoxItem {

		public object ObjectData;

		public CustomListBoxItem() {
		}

		public CustomListBoxItem(object content, object data) {
			ObjectData = data;
			Content = content;
		}

	}

	public class TextValueComboBoxItem : ComboBoxItem {

		
		public static DependencyProperty TextProperty;
		public static DependencyProperty ValueProperty;

		static TextValueComboBoxItem() {
			TextProperty = DependencyProperty.Register("Text", typeof(string), typeof(TextValueComboBoxItem), new PropertyMetadata("",new PropertyChangedCallback(TextPropertyChanged)));
			ValueProperty = DependencyProperty.Register("Value", typeof(string), typeof(TextValueComboBoxItem), new PropertyMetadata(""));
		}

		public static void TextPropertyChanged(DependencyObject dependenyObject, DependencyPropertyChangedEventArgs e){
			TextValueComboBoxItem obj = (TextValueComboBoxItem)dependenyObject;
			obj.Content = obj.Text;
		}

		public string Text {
			get {
				return (string)base.GetValue(TextProperty);
			}
			set {
				base.SetValue(TextProperty, value);
			}
		}

		public string Value {
			get {
				return (string)base.GetValue(ValueProperty);
			}
			set {
				base.SetValue(ValueProperty, value);
			}
		}

		public TextValueComboBoxItem() {
		}

		public TextValueComboBoxItem(string text, string value) {
			Text = text;
			Value = value;
		}

	}

	public class CustomContextMenuItem : MenuItem {

		public object ObjectData;

		public CustomContextMenuItem() {
		}

		public CustomContextMenuItem(object header, object data) {
			ObjectData = data;
			Header = header;
		}

	}

}
