﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows;
using System.Windows.Input;
using System.Windows.Shapes;
using System.Windows.Controls.Primitives;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Xml;
using System.Windows.Markup;

namespace OPlanner {

	public class CustomSlider : Slider {

		public event MouseButtonEventHandler ThumbDoubleClick;

		public override void OnApplyTemplate() {
			base.OnApplyTemplate();
			Thumb thumb = FindThumb(this);
			if (thumb != null) {
				thumb.MouseDoubleClick += new MouseButtonEventHandler(thumb_MouseDoubleClick);
			}
		}

		void thumb_MouseDoubleClick(object sender, MouseButtonEventArgs e) {
			if (ThumbDoubleClick != null) {
				ThumbDoubleClick.Invoke(this, e);
			}
		}

		public Thumb FindThumb(DependencyObject obj) {
			for (int i = 0; i < VisualTreeHelper.GetChildrenCount(obj); i++) {
				DependencyObject child = VisualTreeHelper.GetChild(obj, i);
				if (child == null) {
					continue;
				}
				if (child is Thumb) {
					return (Thumb)child;
				}
				Thumb childOfChild = FindThumb(child);
				if (childOfChild != null) {
					return childOfChild;
				}
			}
			return null;
		}

	}

}
