﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Input;

namespace OPlanner {

	public class CustomResult {

		public CustomResult() {
			Message = "";
			success = false;
		}

		public CustomResult(bool success) {
			Success = success;
		}

		public CustomResult(bool success, string message) {
			Message = message;
			Success = success;
		}

		string message;
		public string Message {
			get {
				return message;
			}
			set {
				message = value;
			}
		}

		bool success;
		public bool Success {
			get {
				return success;
			}
			set {
				success = value;
			}
		}

	}

	public class ErrorManager {

		List<string> errors;

		public ErrorManager() {
			errors = new List<string>();
		}

		public void AddError(string message) {
			errors.Add(message);
		}

		public bool HasErrors {
			get {
				if (errors.Count > 0) {
					return true;
				}
				return false;
			}
		}

		public void ShowErrors(Window owner) {
			if (!HasErrors) {
				return;
			}
			ErrorWindow wnd = new ErrorWindow();
			wnd.Owner = owner;
			string errorMessage = "";
			for (int i = 0; i < errors.Count; i++) {
				if (errorMessage != "") {
					errorMessage += "\n";
				}
				errorMessage += errors[i];
			}
			wnd.ErrorMessage = errorMessage;
			wnd.ShowDialog();
		}

	}

}
