﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace OPlanner {
	
	public partial class RenumberControls : Window {

		public RenumberControls() {
			InitializeComponent();
		}

		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
			Clear();
		}

		private void Clear() {
			minimumBox.Text = "";
			shiftButton.IsChecked = true;
		}

		private bool Validate(bool showErrors) {
			ErrorManager errorManager = new ErrorManager();
			int num;
			if (minimumBox.Text == "") {
				errorManager.AddError("Minimum number is required");
			}else{
				if (!int.TryParse(minimumBox.Text, out num)) {
					errorManager.AddError("Minimum number must be an integer");
				} else {
					if (num <= 0) {
						errorManager.AddError("Minimum number must be a positive integer");
					}
				}
			}
			if (showErrors) {
				errorManager.ShowErrors(this);
			}
			return !errorManager.HasErrors;
		}

		private void renumberButton_Click(object sender, RoutedEventArgs e) {
			if (!Validate(true)) {
				return;
			}
			int min = int.Parse(minimumBox.Text);
			info.InvokeDataChanging(this, "Renumber Controls");
			if (shiftButton.IsChecked == true) {
				info.Data.ShiftControlCodes(min);
			} else {
				info.Data.TotallyRenumberControls(min);
			}
			info.InvokeDataChanged(this, "Renumber Controls");
			info.InvokeObjectsUpdated(this, UpdateType.Code, null, true);
			Close();
		}

		private void cancelButton_Click(object sender, RoutedEventArgs e) {
			Close();
		}

	}

}
