﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Controls.Primitives;

namespace OPlanner {

	public partial class ObjectProperties : UserControl {

		public ObjectProperties() {
			InitializeComponent();
			UpdatePanel();
		}

		private DescriptionManager descriptionManager;
		private OBaseObject selectedObject;
		private OCurrentInfo info;

		public void SetInfo(OCurrentInfo newInfo) {
			info = newInfo;
			info.DataLoaded += new BasicEventHandler(DataLoadedHandler);
			info.ObjectsSelected += new SenderEventHandler(ObjectsSelectedHandler);
			info.ObjectsDeselected += new SenderEventHandler(ObjectsSelectedHandler);
			info.ObjectsUpdated += new UpdateEventHandler(ObjectsUpdatedHandler);
			info.ObjectsCreated += new SenderEventHandler(ObjectsSelectedHandler);
			info.CourseViewModeChanged += new SenderEventHandler(ViewModeChangedHandler);
		}

		private void DataLoadedHandler() {
			UpdatePanel();
		}

		private void ObjectsSelectedHandler(object sender) {
			Save();
			UpdatePanel();
		}

		private void ViewModeChangedHandler(object sender) {
			UpdatePanel();
		}

		private void ObjectsUpdatedHandler(object sender, UpdateType updateType, List<OBaseObject> objects, bool updatePropertiesPanel) {
			if (updatePropertiesPanel == false) {
				return;
			}
			if (selectedObject == null) {
				return;
			}
			if (objects == null) {
				UpdatePanel();
				return;
			}
			for (int i = 0; i < objects.Count; i++) {
				if (selectedObject.MatchesObject(objects[i])) {
					UpdatePanel();
					return;
				}
			}
		}

		public void LoadDescriptions(DescriptionManager manager) {
			descriptionManager = manager;
			for (int i = 0; i < pictorialPanel.Children.Count; i++) {
				DescriptionsHeader header = pictorialPanel.Children[i] as DescriptionsHeader;
				if (header != null) {
					header.LoadDescriptions(manager);
				}
			}
		}

		private void UpdateDescription() {
			descriptionSymbolPanel.Visibility = Visibility.Collapsed;
			for (int i = 0; i < pictorialPanel.Children.Count;i++) {
				DescriptionsHeader header = pictorialPanel.Children[i] as DescriptionsHeader;
				if (header != null) {
					header.SetDescription(null);
				}
			}
			if (selectedObject == null) {
				return;
			}
			if (descriptionManager == null) {
				return;
			}
			ISymbolDescription symbolObj = (ISymbolDescription)selectedObject.GetObject(typeof(ISymbolDescription));
			if (symbolObj == null) {
				return;
			}
			descriptionPanel.Visibility = Visibility.Visible;
			descriptionSymbolPanel.Visibility = Visibility.Visible;
			for (int i = 0; i < pictorialPanel.Children.Count; i++) {
				DescriptionsHeader header = pictorialPanel.Children[i] as DescriptionsHeader;
				if (header != null) {
					string code = symbolObj.GetDescription(header.Column);
					DescriptionSymbol symbol = descriptionManager.GetSymbolByCode(code);
					if (symbol != null) {
						header.SetDescription(symbol.GetSymbol(OPlannerDefaults.DescriptionSize, Brushes.Black));
					}
					if (header.Column == 6) {
						Size size = symbolObj.GetFeatureSize(); 
						header.SetFeatureSize(size.Width, size.Height);
						if (size.Width != 0 || size.Height !=0) {
							StackPanel sizePanel = new StackPanel();
							sizePanel.VerticalAlignment = VerticalAlignment.Center;
							if (size.Width != 0) {
								TextBlock textBlock = new TextBlock();
								textBlock.Text = size.Width.ToString();
								textBlock.HorizontalAlignment = HorizontalAlignment.Center;
								sizePanel.Children.Add(textBlock);
							}
							if (size.Height != 0) {
								TextBlock textBlock = new TextBlock();
								textBlock.Text = size.Height.ToString();
								textBlock.HorizontalAlignment = HorizontalAlignment.Center;
								sizePanel.Children.Add(textBlock);
							}
							header.SetDescription(sizePanel);
						}
					}
				}
			}
		}

		private void UpdatePanel() {
			if (info == null) {
				selectedObject = null;
			} else {
				if (info.SelectedObjects.Count == 1) {
					selectedObject = info.SelectedObjects[0];
					if (selectedObject.GetCourse() == null) {
						if (info.SelectedCourse != null) {
							List<OBaseObject> matches = info.SelectedCourse.GetMatches(selectedObject);
							if (matches.Count > 1) {
								selectedObject = null;
							} else if (matches.Count == 1) {
								selectedObject = matches[0];
							}
						} else {
							for (int i = 0; i < info.Data.AllControls.Count; i++) {
								if (info.Data.AllControls[i].MatchesObject(selectedObject)) {
									selectedObject = info.Data.AllControls[i];
									continue;
								}
							}
						}
					}
				} else {
					selectedObject = null;
				}
			}
			descriptionPanel.Visibility = Visibility.Collapsed;
			descriptionTextPanel.Visibility = Visibility.Collapsed;
			codePanel.Visibility = Visibility.Collapsed;
			positionPanel.Visibility = Visibility.Collapsed;
			autoLinePanel.Visibility = Visibility.Collapsed;
			numberOffsetManualPanel.Visibility = Visibility.Collapsed;
			numberOffsetPanel.Visibility = Visibility.Collapsed;
			numberTextManualPanel.Visibility = Visibility.Collapsed;
			numberTextPanel.Visibility = Visibility.Collapsed;
			descriptionLabel.Visibility = Visibility.Collapsed;
			rotationPanel.Visibility = Visibility.Collapsed;
			sizePanel.Visibility = Visibility.Collapsed;
			opacityPanel.Visibility = Visibility.Collapsed;
			displayGloballyPanel.Visibility = Visibility.Collapsed;
			checkBoxPanel.Visibility = Visibility.Collapsed;
			textPanel.Visibility = Visibility.Collapsed;
			descriptionTypePanel.Visibility = Visibility.Collapsed;
			distancePanel.Visibility = Visibility.Collapsed;
			titlePanel.Visibility = Visibility.Collapsed;
			maxRowsPanel.Visibility = Visibility.Collapsed;
			xText.Text = "";
			yText.Text = "";
			codeText.Text = "";
			descriptionTextText.Text = "";
			textText.Text = "";
			numberXOffset.Text = "";
			numberYOffset.Text = "";
			numberTextBox.Text = "";
			rotationText.Text = "";
			sizeText.Text = "";
			opacityText.Text = "";
			distanceLabel.Content = "";
			titleText.Text = "";
			maxRowsText.Text = "";
			UpdateDescription();
			if (selectedObject == null) {
				mainPanel.IsEnabled = false;
				return;
			}
			mainPanel.IsEnabled = true;
			ODistanceMeasure distanceMeasure = (ODistanceMeasure)selectedObject.GetObject(typeof(ODistanceMeasure));
			if (distanceMeasure != null) {
				distancePanel.Visibility = Visibility.Visible;
				string distance = Math.Round(OPlannerHelper.PixelsToMillimetres(distanceMeasure.GetLength())/1000.0*info.Data.MapScale).ToString() + " m";
				distanceLabel.Content = distance;
				return;
			}
			ICodeObject codeObj = (ICodeObject)selectedObject.GetObject(typeof(ICodeObject));
			if (codeObj != null) {
				codePanel.Visibility = Visibility.Visible;
				codeText.Text = codeObj.ObjectCode;
			}
			ITextDescription descriptionTextObj = (ITextDescription)selectedObject.GetObject(typeof(ITextDescription));
			if (descriptionTextObj != null) {
				descriptionPanel.Visibility = Visibility.Visible;
				descriptionTextPanel.Visibility = Visibility.Visible;
				descriptionTextText.Text = descriptionTextObj.TextDescription;
			}
			IText textObj = (IText)selectedObject.GetObject(typeof(IText));
			if (textObj != null) {
				textPanel.Visibility = Visibility.Visible;
				textText.Text = textObj.Text;
			}
			IMapObject mapObj = (IMapObject)selectedObject.GetObject(typeof(IMapObject));
			if (mapObj != null) {
				positionPanel.Visibility = Visibility.Visible;
				xText.Text = Convert.ToString(mapObj.X);
				yText.Text = Convert.ToString(mapObj.Y);
			}
			IRotatableObject rotObj = (IRotatableObject)selectedObject.GetObject(typeof(IRotatableObject));
			if (rotObj != null) {
				rotationPanel.Visibility = Visibility.Visible;
				rotationText.Text = Convert.ToString(rotObj.Rotation);
			}
			IOneSizeable sizeObj = (IOneSizeable)selectedObject.GetObject(typeof(IOneSizeable));
			if (sizeObj != null) {
				sizePanel.Visibility = Visibility.Visible;
				sizeText.Text = Convert.ToString(sizeObj.Size);
			}
			IOpacityObject opacityObj = (IOpacityObject)selectedObject.GetObject(typeof(IOpacityObject));
			if (opacityObj != null) {
				opacityPanel.Visibility = Visibility.Visible;
				opacityText.Text = Convert.ToString(opacityObj.Opacity);
			}
			IAutoJoin connectableObjRef = (IAutoJoin)selectedObject.GetObject(typeof(IAutoJoin));
			if (connectableObjRef != null && selectedObject.GetCourse() != null) {
				checkBoxPanel.Visibility = Visibility.Visible;
				autoLinePanel.Visibility = Visibility.Visible;
				autoLine.IsChecked = connectableObjRef.AutoJoin;
			}
			IGlobalObject globalObj = (IGlobalObject)selectedObject.GetObject(typeof(IGlobalObject));
			if (globalObj != null && globalObj.GetCourse() == null) {
				checkBoxPanel.Visibility = Visibility.Visible;
				displayGloballyPanel.Visibility = Visibility.Visible;
				displayGlobally.IsChecked = globalObj.DisplayGlobally;
			}
			OCourseControl courseControl = (OCourseControl)selectedObject.GetObject(typeof(OCourseControl));
			if (courseControl != null) {
				if (info.CourseViewType == CourseViewType.Preview) {
					numberOffsetPanel.Visibility = Visibility.Visible;
				}
				if (courseControl.NumberOffsetType == AutoManual.Manual) {
					numberOffsetManual.IsChecked = true;
					numberOffsetManualPanel.Visibility = Visibility.Visible;
					numberXOffset.Text = Convert.ToString(courseControl.NumberXOffset);
					numberYOffset.Text = Convert.ToString(courseControl.NumberYOffset);
				} else {
					numberOffsetAuto.IsChecked = true;
				}
				numberTextPanel.Visibility = Visibility.Visible;
				if (courseControl.NumberType == AutoManualNone.Manual) {
					numberTextManual.IsChecked = true;
					numberTextManualPanel.Visibility = Visibility.Visible;
					numberTextBox.Text = courseControl.NumberText;
				} else if (courseControl.NumberType == AutoManualNone.Auto) {
					numberTextAuto.IsChecked = true;
				} else {
					numberTextNone.IsChecked = true;
				}
			}
			OCourseDescriptions courseDescriptions = (OCourseDescriptions)selectedObject.GetObject(typeof(OCourseDescriptions));
			if (courseDescriptions != null) {
				descriptionTypePanel.Visibility = Visibility.Visible;
				titlePanel.Visibility = Visibility.Visible;
				maxRowsPanel.Visibility = Visibility.Visible;
				if (courseDescriptions.IsText == false) {
					descriptionTypeSymbol.IsChecked = true;
				} else {
					descriptionTypeText.IsChecked = true;
				}
				if (courseDescriptions.Title != null) {
					titleText.Text = courseDescriptions.Title;
				}
				if (courseDescriptions.MaxRows > 0) {
					maxRowsText.Text = courseDescriptions.MaxRows.ToString();
				}
			}
		}

		private void codeText_LostFocus(object sender, RoutedEventArgs e) {
			SaveCode();
		}

		private void xText_LostFocus(object sender, RoutedEventArgs e) {
			SaveX();
		}

		private void yText_LostFocus(object sender, RoutedEventArgs e) {
			SaveY();
		}

		private void rotationText_LostFocus(object sender, RoutedEventArgs e) {
			SaveRotation();
		}

		private void sizeText_LostFocus(object sender, RoutedEventArgs e) {
			SaveSize();
		}

		private void opacityText_LostFocus(object sender, RoutedEventArgs e) {
			SaveOpacity();
		}

		private void descriptionTextText_LostFocus(object sender, RoutedEventArgs e) {
			SaveDescriptionText();
		}

		private void textText_LostFocus(object sender, RoutedEventArgs e) {
			SaveText();
		}

		private void titleText_LostFocus(object sender, RoutedEventArgs e) {
			SaveTitle();
		}

		private void maxRowsText_LostFocus(object sender, RoutedEventArgs e) {
			SaveMaxRows();
		}

		private void SaveCode() {
			if (selectedObject == null) {
				return;
			}
			ICodeObject obj = (ICodeObject)selectedObject.GetObject(typeof(ICodeObject));
			if (obj == null) {
				return;
			}
			if (obj.ObjectCode == codeText.Text) {
				return;
			}
			if (codeText.Text == "" || codeText.Text == null) {
				ErrorManager errorManager = new ErrorManager();
				errorManager.AddError("A code is required");
				errorManager.ShowErrors(OPlannerHelper.MainWindow);
				codeText.Text = obj.ObjectCode;
				return;
			}
			if (obj.Parent.GetObjectByCode(codeText.Text) != null) {
				ErrorManager errorManager = new ErrorManager();
				errorManager.AddError("Code already exists");
				errorManager.ShowErrors(OPlannerHelper.MainWindow);
				codeText.Text = obj.ObjectCode;
				return;
			}
			info.InvokeDataChanging(this, "Change Object Code");
			obj.ObjectCode = codeText.Text;
			info.InvokeDataChanged(this, "Change Object Code");
			info.InvokeObjectsUpdated(this, UpdateType.Code, new List<OBaseObject>(new OBaseObject[]{selectedObject}), true);
		}

		private void SaveX() {
			if (selectedObject == null) {
				return;
			}
			IMapObject obj = (IMapObject)selectedObject.GetObject(typeof(IMapObject));
			if (obj == null) {
				return;
			}
			double x;
			if (!double.TryParse(xText.Text, out x)) {
				xText.Text = Convert.ToString(obj.X);
				return;
			}
			if (Math.Abs(x - obj.X) < 0.0000001) {//
				return;
			}
			info.InvokeDataChanging(this, "Move Object");
			obj.X = x;
			info.InvokeDataChanged(this, "Move Object");
			info.InvokeObjectsUpdated(this, UpdateType.Move, new List<OBaseObject>(new OBaseObject[] { selectedObject }),true);
		}

		private void SaveY() {
			if (selectedObject == null) {
				return;
			}
			IMapObject obj = (IMapObject)selectedObject.GetObject(typeof(IMapObject));
			if (obj == null) {
				return;
			}
			double y;
			if (!double.TryParse(yText.Text, out y)) {
				yText.Text = Convert.ToString(obj.Y);
				return;
			}
			if (Math.Abs(y - obj.Y) < 0.0000001) {//
				return;
			}
			info.InvokeDataChanging(this, "Move Object");
			obj.Y = y;
			info.InvokeDataChanged(this, "Move Object");
			info.InvokeObjectsUpdated(this, UpdateType.Move, new List<OBaseObject>(new OBaseObject[] { selectedObject }),true);
		}

		private void SaveRotation() {
			if (selectedObject == null) {
				return;
			}
			IRotatableObject obj = (IRotatableObject)selectedObject.GetObject(typeof(IRotatableObject));
			if (obj == null) {
				return;
			}
			double num;
			if (!double.TryParse(rotationText.Text, out num)) {
				rotationText.Text = Convert.ToString(obj.Rotation);
				return;
			}
			if (Math.Abs(num - obj.Rotation) < 0.0000001) {//
				return;
			}
			info.InvokeDataChanging(this, "Rotate Object");
			obj.Rotation = num;
			info.InvokeDataChanged(this, "Rotate Object");
			info.InvokeObjectsUpdated(this, UpdateType.Rotate, new List<OBaseObject>(new OBaseObject[] { selectedObject }),true);
		}

		private void SaveSize() {
			if (selectedObject == null) {
				return;
			}
			IOneSizeable obj = (IOneSizeable)selectedObject.GetObject(typeof(IOneSizeable));
			if (obj == null) {
				return;
			}
			double num;
			if (!double.TryParse(sizeText.Text, out num)) {
				sizeText.Text = Convert.ToString(obj.Size);
				return;
			}
			if (num <= 0) {
				sizeText.Text = Convert.ToString(obj.Size);
				return;
			}
			if (Math.Abs(num - obj.Size) < 0.0000001) {//
				return;
			}
			info.InvokeDataChanging(this, "Resize Object");
			obj.Size = num;
			info.InvokeDataChanged(this, "Resize Object");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }),true);
		}

		private void SaveOpacity() {
			if (selectedObject == null) {
				return;
			}
			IOpacityObject obj = (IOpacityObject)selectedObject.GetObject(typeof(IOpacityObject));
			if (obj == null) {
				return;
			}
			double num;
			if (!double.TryParse(opacityText.Text, out num)) {
				opacityText.Text = Convert.ToString(obj.Opacity);
				return;
			}
			if (num < 0 || num > 100) {
				opacityText.Text = Convert.ToString(obj.Opacity);
				return;
			}
			if (Math.Abs(num - obj.Opacity) < 0.0000001) {//
				return;
			}
			info.InvokeDataChanging(this, "Change Opacity");
			obj.Opacity = num;
			info.InvokeDataChanged(this, "Change Opacity");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }),true);
		}

		private void SaveDescriptionText() {
			if (selectedObject == null) {
				return;
			}
			ITextDescription obj = (ITextDescription)selectedObject.GetObject(typeof(ITextDescription));
			if (obj == null) {
				return;
			}
			if (obj.TextDescription == descriptionTextText.Text || obj.TextDescription == null && descriptionTextText.Text == "") {
				return;
			}
			info.InvokeDataChanging(this, "Change Description");
			obj.TextDescription = descriptionTextText.Text;
			info.InvokeDataChanged(this, "Change Description");
			info.InvokeObjectsUpdated(this, UpdateType.Description, new List<OBaseObject>(new OBaseObject[] { selectedObject }),true);
		}

		private void SaveText() {
			if (selectedObject == null) {
				return;
			}
			IText obj = (IText)selectedObject.GetObject(typeof(IText));
			if (obj == null) {
				return;
			}
			if (obj.Text == textText.Text || obj.Text == null && textText.Text == "") {
				return;
			}
			info.InvokeDataChanging(this, "Change Text");
			obj.Text = textText.Text;
			info.InvokeDataChanged(this, "Change Text");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }),true);
		}

		private void SaveTitle() {
			if (selectedObject == null) {
				return;
			}
			OCourseDescriptions obj = (OCourseDescriptions)selectedObject.GetObject(typeof(OCourseDescriptions));
			if (obj == null) {
				return;
			}
			if (obj.Title == titleText.Text || obj.Title == null && titleText.Text == "") {
				return;
			}
			info.InvokeDataChanging(this, "Change Title");
			obj.Title = titleText.Text;
			info.InvokeDataChanged(this, "Change Title");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void SaveMaxRows() {
			if (selectedObject == null) {
				return;
			}
			OCourseDescriptions obj = (OCourseDescriptions)selectedObject.GetObject(typeof(OCourseDescriptions));
			if (obj == null) {
				return;
			}
			int num;
			if (!int.TryParse(maxRowsText.Text, out num)) {
				if (obj.MaxRows > 0) {
					maxRowsText.Text = Convert.ToString(obj.MaxRows);
				} else {
					maxRowsText.Text = "";
				}
				return;
			}
			if (num <= 0) {
				num = 0;
			}
			if (num == obj.MaxRows) {
				if (obj.MaxRows > 0) {
					maxRowsText.Text = Convert.ToString(obj.MaxRows);
				} else {
					maxRowsText.Text = "";
				}
				return;
			}
			info.InvokeDataChanging(this, "Change Max Rows");
			obj.MaxRows = num;
			info.InvokeDataChanged(this, "Change Max Rows");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void DescriptionSelected(string code, int column) {
			if (selectedObject == null) {
				return;
			}
			ISymbolDescription obj = (ISymbolDescription)selectedObject.GetObject(typeof(ISymbolDescription));
			if (obj == null) {
				return;
			}
			if (obj.GetDescription(column) == code) {
				return;
			}
			info.InvokeDataChanging(this, "Change Description");
			obj.SetDescription(column, code);
			info.InvokeDataChanged(this, "Change Description");
			info.InvokeObjectsUpdated(this, UpdateType.Description, null,true);
		}

		private void FeatureSizeSet(double x, double y) {
			if (selectedObject == null) {
				return;
			}
			ISymbolDescription obj = (ISymbolDescription)selectedObject.GetObject(typeof(ISymbolDescription));
			if (obj == null) {
				return;
			}
			info.InvokeDataChanging(this, "Change Description");
			obj.SetFeatureSize(x, y);
			info.InvokeDataChanged(this, "Change Description");
			info.InvokeObjectsUpdated(this, UpdateType.Description, null, true);
		}

		private void Save() {
			if (selectedObject == null) {
				return;
			}
			ODistanceMeasure distanceMeasure = (ODistanceMeasure)selectedObject.GetObject(typeof(ODistanceMeasure));
			if (distanceMeasure != null) {
				return;
			}
			SaveCode();
			SaveX();
			SaveY();
			SaveDescriptionText();
			SaveText();
			SaveNumberXOffset();
			SaveNumberYOffset();
			SaveNumberText();
			SaveRotation();
			SaveSize();
			SaveOpacity();
			SaveTitle();
			SaveMaxRows();
		}

		private void autoLine_Checked(object sender, RoutedEventArgs e) {
			SaveAutoLine();
		}

		private void SaveAutoLine() {
			if (selectedObject == null) {
				return;
			}
			if (selectedObject.GetCourse() == null) {
				return;
			}
			IAutoJoin obj = (IAutoJoin)selectedObject.GetObject(typeof(IAutoJoin));
			if (obj == null) {
				return;
			}
			if (autoLine.IsChecked == obj.AutoJoin) {
				return;
			}
			info.InvokeDataChanging(this, "Update Object");
			obj.AutoJoin = autoLine.IsChecked.Value;
			info.InvokeDataChanged(this, "Update Object");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void displayGlobally_Checked(object sender, RoutedEventArgs e) {
			SaveDisplayGlobally();
		}

		private void SaveDisplayGlobally() {
			if (selectedObject == null) {
				return;
			}
			IGlobalObject obj = (IGlobalObject)selectedObject.GetObject(typeof(IGlobalObject));
			if (obj == null) {
				return;
			}
			if (displayGlobally.IsChecked == obj.DisplayGlobally) {
				return;
			}
			info.InvokeDataChanging(this, "Update Object");
			obj.DisplayGlobally = displayGlobally.IsChecked.Value;
			info.InvokeDataChanged(this, "Update Object");
			info.InvokeObjectsUpdated(this, UpdateType.Display, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void numberOffset_Checked(object sender, RoutedEventArgs e) {
			SaveNumberOffsetType();
		}

		private void SaveNumberOffsetType() {
			if (selectedObject == null) {
				return;
			}
			OCourseControl obj = (OCourseControl)selectedObject.GetObject(typeof(OCourseControl));
			if (obj == null) {
				return;
			}
			AutoManual offsetType = AutoManual.Auto;
			if (numberOffsetManual.IsChecked.Value) {
				offsetType = AutoManual.Manual;
			}
			if (obj.NumberOffsetType == offsetType) {
				return;
			}
			info.InvokeDataChanging(this, "Update Object");
			if (offsetType == AutoManual.Manual) {
				Point offset = obj.GetNumberOffset();
				obj.NumberXOffset = offset.X;
				obj.NumberYOffset = offset.Y;
			}
			obj.NumberOffsetType = offsetType;
			info.InvokeDataChanged(this, "Update Object");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void numberXOffset_PreviewLostKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e) {
			SaveNumberXOffset();
		}

		private void numberYOffset_PreviewLostKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e) {
			SaveNumberYOffset();
		}

		private void SaveNumberXOffset() {
			if (selectedObject == null) {
				return;
			}
			OCourseControl obj = (OCourseControl)selectedObject.GetObject(typeof(OCourseControl));
			if (obj == null) {
				return;
			}
			double x;
			if (!double.TryParse(numberXOffset.Text, out x)) {
				numberXOffset.Text = Convert.ToString(obj.NumberXOffset);
				return;
			}
			if (Math.Abs(x - obj.NumberXOffset) < 0.0000001) {//
				return;
			}
			info.InvokeDataChanging(this, "Move Object");
			obj.NumberXOffset = x;
			info.InvokeDataChanged(this, "Move Object");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void SaveNumberYOffset() {
			if (selectedObject == null) {
				return;
			}
			OCourseControl obj = (OCourseControl)selectedObject.GetObject(typeof(OCourseControl));
			if (obj == null) {
				return;
			}
			double y;
			if (!double.TryParse(numberYOffset.Text, out y)) {
				numberYOffset.Text = Convert.ToString(obj.NumberYOffset);
				return;
			}
			if (Math.Abs(y - obj.NumberYOffset) < 0.0000001) {//
				return;
			}
			info.InvokeDataChanging(this, "Move Object");
			obj.NumberYOffset = y;
			info.InvokeDataChanged(this, "Move Object");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void numberText_Checked(object sender, RoutedEventArgs e) {
			SaveNumberType();
		}

		private void SaveNumberType() {
			if (selectedObject == null) {
				return;
			}
			OCourseControl obj = (OCourseControl)selectedObject.GetObject(typeof(OCourseControl));
			if (obj == null) {
				return;
			}
			AutoManualNone type = AutoManualNone.Auto;
			if (numberTextManual.IsChecked.Value) {
				type = AutoManualNone.Manual;
			} else if (numberTextNone.IsChecked.Value) {
				type = AutoManualNone.None;
			}
			if (obj.NumberType == type) {
				return;
			}
			info.InvokeDataChanging(this, "Update Object");
			obj.NumberType = type;
			info.InvokeDataChanged(this, "Update Object");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void numberTextBox_PreviewLostKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e) {
			SaveNumberText();
		}

		private void SaveNumberText() {
			if (selectedObject == null) {
				return;
			}
			OCourseControl obj = (OCourseControl)selectedObject.GetObject(typeof(OCourseControl));
			if (obj == null) {
				return;
			}
			string text = numberTextBox.Text;
			if (text == obj.NumberText) {
				return;
			}
			info.InvokeDataChanging(this, "Update Object");
			obj.NumberText = text;
			info.InvokeDataChanged(this, "Update Object");
			info.InvokeObjectsUpdated(this, UpdateType.Redraw, new List<OBaseObject>(new OBaseObject[] { selectedObject }), true);
		}

		private void descriptionType_Checked(object sender, RoutedEventArgs e) {
			SaveDescriptionType();
		}

		private void SaveDescriptionType() {
			if (selectedObject == null) {
				return;
			}
			OCourseDescriptions obj = (OCourseDescriptions)selectedObject.GetObject(typeof(OCourseDescriptions));
			if (obj == null) {
				return;
			}
			bool isText;
			if (descriptionTypeSymbol.IsChecked.Value) {
				isText = false;
			} else {
				isText = true;
			}
			if (obj.IsText == isText) {
				return;
			}
			info.InvokeDataChanging(this, "Update Object");
			obj.IsText = isText;
			info.InvokeDataChanged(this, "Update Object");
			info.InvokeObjectsUpdated(this, UpdateType.Description, null, true);
		}

	}

}
