﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace OPlanner {

	public static class OPlannerDefaults {

		public static Size DefaultCanvasSize {
			get {
				return new Size(500, 400);
			}
		}
		public static double NumberOffsetDistance {
			get {
				return OPlannerHelper.MillimetresToPixels(3.7);
			}
		}
		public static double NumberSize {
			get {
				return OPlannerHelper.MillimetresToPixels(6);
			}
		}
		public static double ControlSize {
			get {
				return OPlannerHelper.MillimetresToPixels(6);
			}
		}
		public static string ControlColour {
			get {
				return "#990099";
			}
		}
		public static double TransparentAreaSize {
			get {
				return 3;
			}
		}
		public static double DescriptionSize {
			get {
				return OPlannerHelper.MillimetresToPixels(5.5);
			}
		}
		public static double OTextSize {
			get {
				return Math.Round(OPlannerHelper.MillimetresToPixels(6), 2);
			}
		}
		public static double LineWidth {
			get {
				return OPlannerHelper.MillimetresToPixels(0.4);
			}
		}
		public static double MapScale {
			get {
				return 10000;
			}
		}

	}

}
