﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace OPlanner {

	public class OCourseDescriptionsVisual : OObjectVisual {

		private FrameworkElement descriptionVisual;

		public OCourseDescriptionsVisual() {
			Background = Brushes.Transparent;
		}

		public override void UpdateObject(UpdateType updateType) {
			base.UpdateObject(updateType);
			if (updateType == UpdateType.Description || updateType == UpdateType.Code) {
				DrawObject();
			}
		}

		protected override void DrawObject() {
			base.DrawObject();
			OCourseDescriptions obj = (OCourseDescriptions)ObjectData.GetObject(typeof(OCourseDescriptions));
			if (obj == null) {
				return;
			}
			if ((ObjectData.GetCourse() == null && obj.DisplayGlobally == false) || info.SelectedCourse == null) {
				if (info.CourseViewType == CourseViewType.Outline) {
					Path path = new Path();
					path.Stroke = new SolidColorBrush((Color)ColorConverter.ConvertFromString(ObjectData.GetData().ControlColour));
					path.StrokeThickness = 2;
					path.Data = Geometry.Parse("M 0,0 L 20,0 M 0,-1 L 0,10");
					Content = path;
				} else {
					Content = null;
				}
			} else {
				DescriptionManager descriptionManager = info.DescriptionManager;
				if (descriptionManager == null) {
					return;
				}
				Brush descriptionsBrush = new SolidColorBrush((Color)ColorConverter.ConvertFromString(ObjectData.GetData().ControlColour));
				if (obj.IsText == false) {
					descriptionVisual = descriptionManager.GetDescriptions(info.SelectedCourse, descriptionsBrush, info.Data.DescriptionSize, obj.MaxRows, obj.Title);
				} else {
					descriptionVisual = descriptionManager.GetTextDescriptions(info.SelectedCourse, descriptionsBrush, info.Data.DescriptionSize, obj.MaxRows, obj.Title);
				}
				MainVisual.Content = descriptionVisual;
			}
		}

	}

}
