﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace OPlanner {

	public partial class OControlTextVisual : UserControl {

		public OControlTextVisual() {
			InitializeComponent();
		}

		public bool IsSelected;
		private SelectObjectAdorner adorner;

		public void Select() {
			Deselect();
			IsSelected = true;
			AdornerLayer adornerLayer = AdornerLayer.GetAdornerLayer(this);
			if (adornerLayer == null) {
				return;
			}
			adorner = new SelectObjectAdorner(this);
			adornerLayer.Add(adorner);
		}

		public void Deselect() {
			IsSelected = false;
			AdornerLayer adornerLayer = AdornerLayer.GetAdornerLayer(this);
			if (adornerLayer != null && adorner != null) {
				adornerLayer.Remove(adorner);
			}
		}

		public string Text {
			get {
				return mainText.Text;
			}
			set {
				mainText.Text = value;
			}
		}

		public Size GetSize() {
			Measure(new Size(double.PositiveInfinity, double.PositiveInfinity));
			return DesiredSize;
		}

		public void SetFontSize(double size) {
			mainText.FontSize = size;
		}

		public void SetFontColour(Brush newBrush) {
			mainText.Foreground = newBrush;
		}

	}

}
